<?php declare(strict_types=1);

/*
 * Copyright (c) 2022, land in sicht AG
 *
 * www.land-in-sicht.de - All rights reserved.
 *
 * This is proprietary software. Unauthorized copying
 * of this file, via any medium, is strictly prohibited.
 */

namespace Newland\Toubiz\Poi\Neos\ViewHelpers\Tour;

use Newland\Toubiz\Api\Service\Toubiz\ApiV1\ObjectAdapter\CategoryAdapter;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractConditionViewHelper;

class IfIsSnowSlopeViewHelper extends AbstractConditionViewHelper
{
    public function initializeArguments(): void
    {
        $this->registerArgument('category', 'string', 'The original id of the main category of the POI.', true);
        parent::initializeArguments();
    }

    public static function verdict(array $arguments, RenderingContextInterface $renderingContext): bool
    {
        return in_array($arguments['category'], CategoryAdapter::CATEGORIES_SNOW_SLOPE, true);
    }
}
