import { asyncComponent, loadVue } from './vue';

export function initializeVueApp (element) {
    loadVue().then(Vue => {
        new Vue({
            el: element,
            mounted() {
                this.$el.style.display = '';
            },
            components: {
                TbOpeningTimesParser: asyncComponent(() => import(
                    /* webpackChunkName: "poi-opening-times-basic" */
                    '@newland/assets-neos/Scripts/opening-times/opening-times-parser.vue'
                )),
                TbOpeningTimesLinePreview: asyncComponent(() => import(
                    /* webpackChunkName: "poi-opening-times-basic" */
                    '@newland/assets-neos/Scripts/opening-times/opening-times-line-preview.vue'
                )),
                TbOpeningTimesExtendablePreview: asyncComponent(() => import(
                    /* webpackChunkName: "poi-opening-times-extended" */
                    '@newland/assets-neos/Scripts/opening-times/opening-times-extendable-preview.vue'
                )),
            },
        });
    });
}
