<?php

namespace Newland\Toubiz\Poi\Neos\Domain\Model;

class Tag
{
    const TYPE_BOOLEAN = 'boolean';
    const TYPE_RANGE = 'range';
    const TYPE_STRING = 'string';

    private $attribute = '';

    private $value = '';

    private $attributeType = '';

    private $identifier = '';

    private $title = '';

    public function __construct(
        string $identifier,
        string $title = '',
        string $attribute = '',
        string $value = '',
        string $attributeType = ''
    ) {
        $this->identifier = $identifier;
        $this->attribute = $attribute;
        $this->attributeType = $attributeType;
        $this->title = $title;
        $this->value = $value;
    }

    public function getAttribute(): string
    {
        return $this->attribute;
    }

    public function getValue(): string
    {
        return $this->value;
    }

    public function getAttributeType(): string
    {
        return $this->attributeType;
    }

    public function getIdentifier(): string
    {
        return $this->identifier;
    }

    public function getTitle(): string
    {
        return $this->title;
    }
}
