<?php
namespace Newland\Toubiz\Poi\Neos\Service;

use Neos\ContentRepository\Domain\Model\Node;
use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\Mvc\ActionRequest;
use Neos\Flow\Mvc\Controller\ControllerContext;
use Neos\Neos\Domain\Model\Site;
use Neos\Neos\Domain\Service\ContentContext;

class ContextService
{

    /**
     * @return Node|null
     */
    public function siteNodeFromControllerContext(ControllerContext $controllerContext)
    {
        $request = $controllerContext->getRequest();
        if (!($request instanceof ActionRequest)) {
            return null;
        }

        /** @var mixed $node */
        $node = $request->getInternalArgument('__node');

        if (!($node instanceof Node)) {
            return null;
        }
        return $this->siteNodeFromReferenceNode($node);
    }

    /**
     * @param NodeInterface $node
     * @return Node|null
     */
    public function siteNodeFromReferenceNode(NodeInterface $node)
    {
        $context = $node->getContext();
        if (!($context instanceof ContentContext)) {
            return null;
        }

        return $context->getCurrentSiteNode();
    }

    /**
     * @param NodeInterface $node
     * @return Site|null
     */
    public function siteFromReferenceNode(NodeInterface $node)
    {
        $context = $node->getContext();
        if (!($context instanceof ContentContext)) {
            return null;
        }

        return $context->getCurrentSite();
    }
}
