<?php
namespace Newland\Toubiz\Poi\Neos\DataSource;

use Neos\Flow\Annotations as Flow;
use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Neos\Service\DataSource\AbstractDataSource;
use Newland\Toubiz\Sync\Neos\Domain\Repository\ArticleRepository;

/**
 * @Flow\Scope("singleton")
 */
class CitiesDataSource extends AbstractDataSource
{
    protected static $identifier = 'newland-toubiz-poi-neos-cities';

    /**
     * @var ArticleRepository
     * @Flow\Inject
     */
    protected $articleRepository;

    public function getData(NodeInterface $node = null, array $arguments = []): array
    {
        return $this->articleRepository
            ->createQueryBuilder('article')
            ->innerJoin('article.mainAddress', 'mainAddress')
            ->select(
                'mainAddress.zip as value',
                'CONCAT(mainAddress.zip, \': \', GROUP_CONCAT(DISTINCT mainAddress.city)) as label'
            )
            ->where('mainAddress.zip != :emptyString AND mainAddress.city != :emptyString')
            ->orderBy('mainAddress.zip')
            ->groupBy('mainAddress.zip')
            ->getQuery()
            ->execute([ 'emptyString' => '' ]);
    }
}
