<?php declare(strict_types=1);

namespace Newland\Toubiz\Poi\Neos\Meta;

use Neos\ContentRepository\Domain\Model\Node;
use Neos\Flow\Property\PropertyMapper;
use Newland\NeosMetaTags\Domain\Model\CanonicalUrlGenerator as CanonicalUrlGeneratorInterface;
use Newland\NeosMetaTags\Domain\Model\Scenario;
use Newland\Toubiz\Poi\Neos\Service\ArticleUrlService;
use Newland\Toubiz\Sync\Neos\Domain\Model\Article;
use Neos\Flow\Annotations as Flow;

class CanonicalUrlGenerator implements CanonicalUrlGeneratorInterface
{

    /**
     * @var ArticleUrlService
     * @Flow\Inject()
     */
    protected $articleUrlService;

    /**
     * @var PropertyMapper
     * @Flow\Inject()
     */
    protected $propertyMapper;

    public function generate(Scenario $scenario, $record): ?string
    {
        if (!($record instanceof Article)) {
            return null;
        }

        return $this->articleUrlService->generateUrlByCurrentNode(
            $record,
            $this->propertyMapper->convert($scenario->getNodePath(), Node::class),
            true
        );
    }
}
