<?php
namespace Newland\Toubiz\Poi\Neos\Service;

/*
 * This file is part of the "toubiz-poi-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;

class LinkListService
{
    /**
     * @var array
     * @Flow\InjectConfiguration(package="Newland.Toubiz.Poi.Neos", path="cityDetails.links")
     */
    protected $linksConfiguration;

    /**
     * @var array
     * @Flow\InjectConfiguration(package="Newland.Toubiz.Poi.Neos", path="linkTargets.sites")
     */
    protected $listLinkTargets;

    public function getLinkTargetNodeByClientAndArticleType(int $articleType, string $clientName = 'default'): string
    {
        $configuration = $this->listLinkTargets[$clientName]['lists'] ??
            $this->listLinkTargets['default']['lists'] ?? '';
        return $configuration[$articleType] ?? '';
    }

    public function getCityDetailConfigurationByClient(string $clientName): ?array
    {

        $clientConfiguration = $this->linksConfiguration['sites'][$clientName] ?? [];
        $defaultConfiguration = $this->linksConfiguration['sites']['default'];

        $clientConfiguration = (array) array_replace_recursive($defaultConfiguration, $clientConfiguration);

        if (array_key_exists('enabled', $clientConfiguration) &&
                !$clientConfiguration['enabled']) {
            return null;
        }

        return $clientConfiguration;
    }
}
