<?php declare(strict_types=1);

namespace Newland\Toubiz\Poi\Neos\Tests\Integration\Detail;

use Newland\Toubiz\Poi\Neos\Tests\Integration\IntegrationTestCase;

abstract class AbstractDetailTestCase extends IntegrationTestCase
{

    protected abstract function articleType(): int;

    public function testDoesNotThrowError(): void
    {
        $article = $this->articleFactory->create([ 'mainType' => $this->articleType() ]);
        $uri = $this->articleUrlService->generateUrlByCurrentNode($article, $this->node);

        $response = $this->browser->request($uri);
        $this->assertResponseOk($response);
        $this->assertResponseNotContains('Exception.*', $response);
    }

}
