<?php

namespace Newland\Toubiz\Poi\Neos\Domain\Model;

class Tag
{
    public const TYPE_BOOLEAN = 'boolean';
    public const TYPE_RANGE = 'range';
    public const TYPE_STRING = 'string';

    private $attribute;

    private $value;

    private $attributeType;

    private $identifier;

    private $title;

    /**
     * Tag constructor.
     * @param string $identifier
     * @param string $title
     * @param string $attribute
     * @param string|bool $value
     * @param string $attributeType
     */
    public function __construct(
        string $identifier,
        string $title = '',
        string $attribute = '',
        $value = '',
        string $attributeType = ''
    ) {
        $this->identifier = $identifier;
        $this->attribute = $attribute;
        $this->attributeType = $attributeType;
        $this->title = $title;
        $this->value = $value;
    }

    public function getAttribute(): string
    {
        return $this->attribute;
    }

    public function getValue(): string
    {
        return $this->value;
    }

    public function getAttributeType(): string
    {
        return $this->attributeType;
    }

    public function getIdentifier(): string
    {
        return $this->identifier;
    }

    public function getTitle(): string
    {
        return $this->title;
    }
}
