<?php
namespace Newland\Toubiz\Poi\Neos\ViewHelpers\Topic\Controller;

/*
 * This file is part of the "toubiz-poi-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Neos\FluidAdaptor\Core\Widget\AbstractWidgetController;
use Newland\Toubiz\Poi\Neos\Domain\Repository\TopicRepository;
use Newland\NeosCommon\Domain\Model\Topic;
use Newland\Toubiz\Poi\Neos\Encoder\QueryToAttributesInEncoder;
use Newland\Toubiz\Poi\Neos\Service\RegionService;
use Newland\Toubiz\Sync\Neos\Domain\Filter\ArticleFilter;
use Newland\Toubiz\Sync\Neos\Domain\Repository\ArticleRepository;

class ArticlesController extends AbstractWidgetController
{
    /**
     * @var Topic
     */
    private $topic;
    /**
     * @var array
     */
    private $queryOverride = [];

    /**
     * @var ArticleRepository
     * @Flow\Inject()
     */
    protected $articleRepository;
    /**
     * @var QueryToAttributesInEncoder
     * @Flow\Inject()
     */
    protected $queryEncoder;
    /**
     * @var RegionService
     * @Flow\Inject()
     */
    protected $regionService;

    public function indexAction(): void
    {
        $this->topic = $this->widgetConfiguration['topic'];
        $this->queryOverride = $this->widgetConfiguration['queryOverride'] ?? [];
        $limit = $this->widgetConfiguration['limit'] ?? 11;

        $filter = new ArticleFilter();
        $filter->setLimit($limit);
        $filter->setCategories($this->getCategories());
        $filter->setAttributesIn($this->getAttributesIn());
        $filter->setZips($this->getZips());

        $articles = $this->articleRepository->findByFilter($filter);
        $count = $this->articleRepository->countByFilter($filter, $limit);

        $this->view->assignMultiple(
            [
                'contentArguments' => [
                    'articles' => $articles,
                    'totalCount' => $count['items'],
                ],
            ]
        );
    }

    private function getAttributesIn(): array
    {
        $attributesIn = [];

        if ($this->topic->getType() === TopicRepository::TYPE_ATTRIBUTE) {
            $attributesIn[$this->topic->getIdentifier()] = [
                $this->topic->getValue() === true ? 'true' : $this->topic->getValue(),
            ];
        }

        $attributesFromQueryOverride = $this->queryEncoder->encode($this->queryOverride);

        $attributesIn = array_merge($attributesIn, $attributesFromQueryOverride);

        return $attributesIn;
    }

    private function getCategories(): array
    {
        $categories = [];

        if ($this->topic->getType() === TopicRepository::TYPE_CATEGORY) {
            $categories[$this->topic->getIdentifier()] = $this->topic->getIdentifier();
        }

        if (array_key_exists('categories', $this->queryOverride)) {
            $categories = array_merge($categories, $this->queryOverride['categories']);
        }

        return $categories;
    }

    private function getZips(): array
    {
        $regions = $this->queryOverride['regions'] ?? [];

        return $this->regionService->collectZipsFromRegionKeys($regions, true);
    }
}
