<?php
namespace Newland\Toubiz\Poi\Neos\ViewHelpers\Widget\Controller;

/*
 * This file is part of the "toubiz-poi-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Neos\FluidAdaptor\Core\Widget\AbstractWidgetController;
use Newland\NeosCommon\Service\ConfigurationService;
use Newland\Toubiz\Sync\Neos\Domain\Model\Article;

/**
 * The widget controller for the city list widget.
 */
class MapController extends AbstractWidgetController
{
    /**
     * @var ConfigurationService
     * @Flow\Inject()
     */
    protected $configurationService;

    public function indexAction(): void
    {
        if ((bool) ($this->settings['cityDetails']['map']['enabled'] ?? false) === false) {
            return;
        }

        /** @var Article $article */
        $article = $this->widgetConfiguration['article'];

        $apiKey = $this->configurationService->getCurrentSiteConfiguration(
            $this->widgetConfiguration['node'],
            'Newland.Toubiz.Poi.Neos.staticMap.apiKey'
        );

        $this->view->assignMultiple(
            [
                'article' => $article,
                'mapApiKey' => $apiKey,
            ]
        );
    }
}
