# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [unreleased]
### Added
- Multisite websites can now specify one google maps API key to use in article detail pages
  per site.
- Resort attributes are now displayed on article detail pages.
- It is now possible to create a shortcut node pointing to an article detail page.
- Cities (Orts-POI) are now imported from Toubiz and have their own set of list and detail
 pages.
- Widgets that build the City Page Details. The configuration can is the under:
```yaml
        cityDetails:
          defaultTranslation:
            package: Newland.Toubiz.Poi.Neos
            source: Views/Cities
          links:
            data:
              restaurants:
                target: 'node://4d8c8785-eae1-474a-9ecb-1775360246ab'
              tours:
                target: 'node://6889fd78-f19c-4136-82a8-e62b94ee28fa'
              events:
                target: 'node://b5ed49ea-685d-4563-8d05-4d134e27bfd3'
              lodgings:
                target: 'node://a2c4f0c5-003b-403d-9b6b-9c4b771e6c7b'
              attractions:
                target: 'node://a0829ac0-5a9a-4ad1-b7c5-fbb03a482ea6'
```

### Fixed
- Fixed preselected properties in POI lists not being applied.
- Fixed some attributes on detail pages being HTML encoded causing HTML-tags in the content
  to be printed to the user.

### Changed
- Gastronomy records are now displayed with all of their categories on the detail page.

### Action Required
- Static map API Keys must now be organized by the node-name of the website they apply for.
  The key `default` will apply as a fallback.

```yaml
# Before
Newland:
  Toubiz:
    Poi:
      Neos:
        staticMap:
          apiKey: 'abcdef'

# After
Newland:
  Toubiz:
    Poi:
      Neos:
        staticMap:
          apiKey:
            default: 'abcdef'
            'newland-tuntheme': 'abcdef'
            radolfzell: 'abcdef'
```

## [1.10.2] - 2019-06-19
### Added
- Breadcrumb configuration can now be defined on a per-site basis using the
  articles node name as a key. For more information please refer to `README.md`.
  Existing configuration will continue working for now but support for it will be
  removed with the next release. Please update your breadcrumb configuration to use
  keys under `breadcrumb` (at least use `_fallback` if you don't differentiate between)
  sites.

```yaml
# Before:
Newland:
  Toubiz:
    Poi:
      Neos:
        detailPage:
          2:
            breadcrumb:
              - '/sites/foobar-theme/node-abc123def'
              - '/sites/foobar-theme/node-abc123def/node-49494949'

# After
Newland:
  Toubiz:
    Poi:
      Neos:
        detailPage:
          2:
            breadcrumb:
              _fallback:
                - '/sites/foobar-theme/node-abc123def'
                - '/sites/foobar-theme/node-abc123def/node-49494949'
              # Site specific breadcrumbs can be added here.
```

- POI detail pages can now use a domain-specific map api key.
  Check the README.md for a configuration example.

## [1.10.1] - 2019-06-07
### Fixed
- Fixed incorrect output of gastronomyStyle attribute

## [1.10.0] - 2019-06-07
### Added
- New backend module for article statistics (popular tags for POI)
- Congress location teaser added.
- Two new node migrations for the preselection filters. They are `Version20190521113800` and `Version20190521161500`
  Check the readme for how to run them.
- New ability to preselect tags for lists. This allows restricting a list by the tag attribute in the backend.
- Thermal & Accessibility attributes are now being imported

### Changed
- TPortal detail URLs are now being handled at import time and are now part of the `Newland.Toubiz.Sync.Neos` configuration.
- Preselection filters are now split in to Categories, Properties and Tags.
- Data sources for articles can no be limited to main type.
- Gastronomy articles now display the description in detail view.
- Opening times are now being displayed as human readable text (e.g. "Closes soon, reopens 14:00")

### Fixed
- Category filter options are now language aware.
- Data sources for articles and categories are now language aware.
- Detail URLs now contain a unique identifier. This prevents multiple records with the same title from
  having `-1` appended to them. Request to the old detail URLs will be redirected accordingly.
- Gastronomy articles now always display the description in detail view.
- Similar articles are now displayed for tours only instead of for all articles _but_ tours.

### Removed
- OnSite / nearby articles are not displayed anymore for non-tours.

### Potentially breaking / Action required
- Two new node migrations for the preselection filters. They are `Version20190521113800` and `Version20190521161500`
  These migrations split the preselected topics filter in the backend in to 3 different ones - Tags, Categories and properties.
  You can run them by executing the following command:
  - `php flow node:migrate 20190521161500`
  - `php flow node:migrate 20190521113800`
- The `poi:context.tportalBaseUri` viewhelper has been removed due to substantial changes in how tportal uris are handled.
  Your sites quickfinder may be using this viewhelper in order to generate a form uri. In that case calls can be replaced
  in the following way:
  ```html
    <!-- before -->
    <form action="{poi:context.tportalBaseUri(targetBaseUri: tportal.targetBaseUri, targetUriSegment: tportal.targetUriSegment)}"></form>

      <!-- after -->
      <form action="{tportal.targetBaseUri}/{tportal.targetUriSegment}/ukv"></form>
  ```
  In case you are using the viewhelper without arguments (or in case of the arguments being `null`) please note the deprecation
  of the `Newland.Toubiz.Poi.lodging` configuration which was used in that case. Please move the configuration into the format
  mentioned in the example.
- TPortal detail URLs can now be configured in the `Newland.Toubiz.Sync.Neos` configuration.
  The `Newland.Toubiz.Poi.lodging` configuration is now deprecated and will be removed in the next version.
  Please adjust your configuration and re-sync in order to prevent undefined behaviour.
  ```yaml
  # Before
  Newland:
    Toubiz:
      Poi:
        Neos:
          lodging:
            targetBaseUri: 'https://www.bodenseewest.eu'
  
  # After
  Newland:
    Toubiz:
      Sync:
        Neos:
          services:
            'Tportal/Api':
              westlicherbodensee:
                client: westlicherbodensee
                detailUri: 'https://www.bodenseewest.eu/{tportalUriSegment}'
  ```

## [1.8.2] - 2019-05-17
### Changed
- ArticleIndexer is now compatible with Search 1.1.0
- Scope name of article indexer has changed to `toubiz_articles`

### Potentially breaking
- This package now requires Search 1.1.0 or later

## [1.8.1] - 2019-05-09
### Added
- Hook to build article URLs on sync

### Fixed
- Previously selected non-existent topics are now displayed in backend to allow removing them

## [1.8.0] - 2019-05-08
### Added
- POIs are now language aware

### Changed
- Gallery images are now displayed in the order as defined during import 
- Article attributes are not checked for existence when populating the pre-filter field in the backend

## [1.7.1] - 2019-04-18
### Fixed
- Fixed days in opening times being offset by 1
- Opening times table now takes non-regular opening times into account
- Opening times are no longer displayed if none exist

### Changed
- Opening Times Table now starts at the current day

## [1.7.0] - 2019-04-17
### Added
- Opening times to article detail view 
- Attributes for Direct Marketers are now synched and displayed 
- New social media information is now fetched 
- Templates for direct marketers

### Changed
- tportalViewHelper adapted to allow fixed properties 
- Prefiltered regions are applied on more than just one filtered list.
- Dependency to toubiz-search-neos is now versions instead of a specific feature branch.

### Fixed
- Galery duplicates

## [1.6.0] - 2019-04-04
### Added
- Support for custom breadcrumbs for detail pages.
- Support for multilingual detail pages
- LinkHandler support is now bundled by default.

### Changed
- `Newland.Toubiz.Poi.Neos:List` is now `Newland.Toubiz.Poi.Neos:List*` for each article type
- `Newland.Toubiz.Poi.Neos:TeaserList` is now `Newland.Toubiz.Poi.Neos:TeaserList*` for each article type

### Fixed
- Ajax results now generate correct frontend links

### Migration Notes
- Use `$ php flow node:migrate --version 20190314223200` to automatically migrate all lists
- Use `$ php flow node:migrate --version 20190314223900` to automatically migrate all teaser lists
- If you project has Linkhandler configuration (In `Newland.NeosCommon.linkhandler`)
  for Articles under the name `poi` then that configuration can be safely removed.

## [1.5.1] - 2019-03-08
- No functional changes

## [1.5.0] - 2019-03-08
### Added
- FilteredLists and TeaserLists can now be pre-filtered by regions. Regions can
be anything from a group of zip codes to a group of other regions.
- FilteredLists Plugin with a landing page displaying swipers and a grid view with many, many configurable filter options
- Article Detail views are now located on static routes that can be configured
on a per-type basis in `Newland.Toubiz.Poi.Neos.detailPage`. Previous detail URLs
are automatically redirected to the new ones.
- A new `Newland.Article.findByIdentifier` fusion helper has been added.
- Attribute cache can now be rebuilt manually via command `attribute:buildcache`.
- Added a Node Migration to change a legacy property on Teaser Lists

### Changed
- The `List` plugin now has filters associated with it.

### Migration Notices
- Be sure to include the `newland/page-frame-provider` repository in your projects `composer.json`
- Be sure to run `php flow node:migrate` on deployment to correctly adapt existing teaser lists
to the current property, if you want to check the status run `php flow node:migrationstatus`.
