<?php declare(strict_types=1);


namespace Newland\Toubiz\Poi\Neos\Tests\Factory;


use Faker\Generator;
use Neos\Flow\Persistence\PersistenceManagerInterface;
use Newland\Toubiz\Sync\Neos\Domain\Model\Address;

class AddressFactory
{

    public static function make(Generator $faker, array $attributes = []): Address
    {
        $address = new Address();
        $address->setOriginalId($attributes['originalId'] ?? $faker->uuid);
        $address->setName($attributes['name'] ?? $faker->name);
        $address->setCity($attributes['city'] ?? $faker->city);
        $address->setFirstName($attributes['firstName'] ?? $faker->firstName);
        $address->setLastName($attributes['lastName'] ?? $faker->lastName);
        $address->setLatitude($attributes['latitude'] ?? $faker->latitude);
        $address->setLongitude($attributes['longitude'] ?? $faker->longitude);
        $address->setStreet($attributes['street'] ?? $faker->streetName);
        $address->setCountry($attributes['country'] ?? $faker->country);
        $address->setEmailAddress($attributes['eMailAddress'] ?? $faker->email);
        $address->setPhoneNumber($attributes['phoneNumber'] ?? $faker->phoneNumber);
        $address->setWebsiteAddress($attributes['websiteAddress'] ?? $faker->url);
        return $address;
    }

}