<?php
namespace Newland\Toubiz\Poi\Neos\ViewHelpers\Widget\Controller;

/*
 * This file is part of the "toubiz-poi-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\Node;
use Neos\Eel\FlowQuery\FlowQuery;
use Neos\Flow\Annotations as Flow;
use Neos\FluidAdaptor\Core\Widget\AbstractWidgetController;
use Newland\Toubiz\Poi\Neos\Domain\Repository\TopicRepository;
use Newland\Toubiz\Sync\Neos\Domain\Filter\ArticleFilter;
use Newland\Toubiz\Sync\Neos\Domain\Model\Article;
use Newland\Toubiz\Sync\Neos\Domain\Model\Category;

/**
 * The widget controller for the city list widget.
 */
class MapController extends AbstractWidgetController
{

    /**
     * @var TopicRepository
     * @Flow\Inject
     */
    protected $topicRepository;

    /**
     * @var array
     * @Flow\InjectConfiguration(package="Newland.Toubiz.Poi.Neos")
     */
    protected $configuration;

    public function indexAction(): void
    {
        if (!array_key_exists('map', $this->settings['cityDetails'])
            || $this->settings['cityDetails']['map']['enabled'] === false
        ) {
            return;
        }
        /** @var Article $article */
        $article = $this->widgetConfiguration['article'];
        $this->view->assignMultiple(
            [
                'article' => $article,
                'configuration' => $this->configuration,
                'mapApiKey' => $this->configuration['staticMap']['apiKey'],
            ]
        );
    }
}
