<?php
namespace Newland\Toubiz\Poi\Neos\DataSource;

use Neos\Flow\Annotations as Flow;
use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Neos\Service\DataSource\AbstractDataSource;
use Newland\Toubiz\Poi\Neos\Service\RegionService;

/**
 * @Flow\Scope("singleton")
 */
class RegionsDataSource extends AbstractDataSource
{
    protected static $identifier = 'newland-toubiz-poi-neos-regions';

    /**
     * @var RegionService
     * @Flow\Inject()
     */
    protected $regionService;

    public function getData(NodeInterface $node = null, array $arguments = []): array
    {
        $regions = [];
        foreach ($this->regionService->getAllEnabled() as $key => $region) {
            $regions[] = [ 'label' => $region['name'], 'value' => $key ];
        }
        return $regions;
    }
}
