<?php
namespace Newland\Toubiz\Poi\Neos\ViewHelpers\Widget;

/*
 * This file is part of the "toubiz-poi-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\Annotations as Flow;
use Neos\FluidAdaptor\Core\Widget\AbstractWidgetViewHelper;
use Newland\Toubiz\Poi\Neos\ViewHelpers\Widget\Controller\MapController;
use Newland\Toubiz\Sync\Neos\Domain\Model\Article;

/**
 * Renders the map widget.
 */
class MapViewHelper extends AbstractWidgetViewHelper
{
    /**
     * @Flow\Inject
     * @var MapController
     */
    protected $controller;

    /**
     * Render this view helper.
     *
     * @param NodeInterface $node   The current node.
     * @param Article $article
     * @return string
     */
    public function render(NodeInterface $node, Article $article): string
    {
        return $this->initiateSubRequest()->getContent();
    }
}
