<?php
namespace Newland\Toubiz\Poi\Neos\Service;

/*
 * This file is part of the "toubiz-poi-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Poi\Neos\Utility\ArrayUtility;

class ClientService
{
    /**
     * @var array
     * @Flow\InjectConfiguration
     */
    protected $configuration;

    public function getCurrentLodgingClient(string $currentSite)
    {
        $path = 'clientFilter.' . $currentSite . '.mainType.values.3';

        return ArrayUtility::get($this->configuration, $path, '');
    }
}
