<?php
namespace Newland\Toubiz\Poi\Neos\ViewHelpers\Widget\Controller;

/*
 * This file is part of the "toubiz-poi-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\Node;
use Neos\Eel\FlowQuery\FlowQuery;
use Neos\Flow\Annotations as Flow;
use Neos\FluidAdaptor\Core\Widget\AbstractWidgetController;
use Newland\Toubiz\Poi\Neos\Domain\Repository\TopicRepository;
use Newland\Toubiz\Sync\Neos\Domain\Filter\ArticleFilter;
use Newland\Toubiz\Sync\Neos\Domain\Model\Article;
use Newland\Toubiz\Sync\Neos\Domain\Model\Category;

/**
 * The widget controller for the city list widget.
 */
class CityListController extends AbstractWidgetController
{

    /**
     * @var TopicRepository
     * @Flow\Inject
     */
    protected $topicRepository;

    public function indexAction(): void
    {
        /** @var Article $article */
        $article = $this->widgetConfiguration['article'];

        $categoryIds = [];
        foreach ($article->getCategories() as $category) {
            $categoryIds[] = 'category:' . $category->getPersistenceObjectIdentifier();
        }
        $lists = $this->topicRepository->findByIdentifiers($categoryIds);
        $this->view->assignMultiple(
            [
                'lists' => $lists,
                'node' => null
            ]
        );
    }
}
