<?php
namespace Newland\Toubiz\Poi\Neos\DataSource;

/*
 * This file is part of the "toubiz-poi-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\Annotations as Flow;
use Neos\Neos\Service\DataSource\AbstractDataSource;
use Newland\Toubiz\Api\ObjectAdapter\Concern\ArticleConstants;

/**
 * POI data source service.
 *
 * @Flow\Scope("singleton")
 */
class ArticleTypeDataSource extends AbstractDataSource
{
    /**
     * @var string Data source identifier.
     */
    protected static $identifier = 'newland-toubiz-poi-neos-articletype';

    /**
     * Get requested data from source.
     *
     * The return value must be JSON serializable data structure.
     *
     * @api
     * @param NodeInterface $node The node that is currently edited (optional)
     * @param array $arguments Additional arguments (key / value)
     * @return mixed JSON serializable data
     */
    public function getData(NodeInterface $node = null, array $arguments = [])
    {
        $data = [
            [
                'label' => 'Attraction',
                'value' => ArticleConstants::TYPE_ATTRACTION,
            ],
            [
                'label' => 'Gastronomy',
                'value' => ArticleConstants::TYPE_GASTRONOMY,
            ],
            [
                'label' => 'Tour',
                'value' => ArticleConstants::TYPE_TOUR,
            ],
        ];

        return $data;
    }
}
