<?php
namespace Newland\Toubiz\Poi\Neos\PageFrame;

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Eel\FlowQuery\FlowQuery;
use Neos\Flow\Annotations as Flow;
use Newland\PageFrameProvider\Definition\RoutingConfigurationHelper;
use Newland\PageFrameProvider\Breadcrumb\BreadcrumbProvider;
use Newland\PageFrameProvider\Service\PageFrameContextService;
use Newland\Toubiz\Sync\Neos\Domain\Model\Article;
use Newland\Toubiz\Sync\Neos\Domain\Repository\ArticleRepository;

class ArticleBreadcrumbProvider implements BreadcrumbProvider
{

    /**
     * @var PageFrameContextService
     * @Flow\Inject()
     */
    protected $pageFrameContext;

    /**
     * @var ArticleRepository
     * @Flow\Inject()
     */
    protected $articleRepository;

    /**
     * @var array
     * @Flow\InjectConfiguration(package="Newland.Toubiz.Poi.Neos", path="detailPage")
     */
    protected $typeConfiguration;

    /**
     * @var RoutingConfigurationHelper
     * @Flow\Inject
     */
    protected $configurationHelper;

    /**
     * @param NodeInterface $siteNode
     * @param array $configuration
     * @return NodeInterface[]
     */
    public function selectBreadCrumbs(NodeInterface $siteNode, array $configuration): array
    {
        $this->configurationHelper->setTypeConfiguration($this->typeConfiguration);
        $article = $this->getArticle();
        if (!$article) {
            return [];
        }

        $definition = $this->configurationHelper->getDefinition((string) $article->getMainType());
        if (!$definition) {
            return [];
        }

        if (empty($definition->getBreadcrumb())) {
            return [];
        }

        $selector = $siteNode->getPath() . ', ' . implode(', ', $definition->getBreadcrumb());
        return (new FlowQuery([ $siteNode ]))->find($selector)->get();
    }

    /**
     * @return Article|null
     */
    private function getArticle()
    {
        $articleUid = $this->pageFrameContext->getPluginArguments()['article'] ?? null;
        if (!$articleUid) {
            return null;
        }

        return $this->articleRepository->findOneBy([ 'Persistence_Object_Identifier' => $articleUid ]);
    }
}
