<?php declare(strict_types=1);
namespace Newland\Toubiz\Poi\Neos\ViewHelpers\Uri\Tportal;

use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;

class ImageViewHelper extends AbstractViewHelper
{
    public function render(string $url, int $width = null): string
    {
        if (!$width) {
            return $url;
        }

        if (str_contains($url, '_sized_')) {
            return $url;
        }

        $bits = explode('.', $url);

        if (count($bits) < 2) {
            return $url;
        }

        $bits[count($bits) - 2] .= sprintf('_sized_%d_0', $width);

        return implode('.', $bits);
    }
}
