<?php declare(strict_types=1);


namespace Newland\Toubiz\Poi\Neos\Tests\Factory;


use Doctrine\Common\Collections\ArrayCollection;
use Faker\Generator;
use Newland\Toubiz\Api\ObjectAdapter\Concern\ArticleConstants;
use Newland\Toubiz\Sync\Neos\Domain\Model\Article;

class ArticleFactory
{

    public static function makeTour(Generator $faker, array $attributes = []): Article
    {
        $article = static::fillGenericArticleProperties(new Article(), $faker, $attributes);
        $article->setMainType(ArticleConstants::TYPE_TOUR);
        return $article;
    }

    private static function fillGenericArticleProperties(Article $article, Generator $faker, array $attributes = []): Article
    {
        $article->setOriginalId($attributes['originalId'] ?? $faker->uuid);
        $article->setName($attributes['name'] ?? $faker->name);
        $article->setDescription($attributes['description'] ?? $faker->text);
        $article->setAbstract($attributes['abstract'] ?? $faker->text);

        $article->setFlickrUri($attributes['flickrUri'] ?? $faker->url);
        $article->setWikipediaUri($attributes['wikipediaUri'] ?? $faker->url);
        $article->setBookingUri($attributes['bookingUri'] ?? $faker->url);
        $article->setFacebookUri($attributes['facebookUri'] ?? $faker->url);
        $article->setInstagramUri($attributes['instagramUri'] ?? $faker->url);
        $article->setYoutubeUri($attributes['youtubeUri'] ?? $faker->url);

        $mainAddressAttributes = $attributes['mainAddress'] ?? [];
        if ($mainAddressAttributes !== false) {
            $article->setMainAddress(AddressFactory::make($faker, $mainAddressAttributes));
        }
        return $article;
    }

}