<?php
namespace Newland\Toubiz\Poi\Neos\ViewHelpers\Widget\Controller;

/*
 * This file is part of the "toubiz-poi-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Neos\FluidAdaptor\Core\Widget\AbstractWidgetController;
use Newland\Toubiz\Sync\Neos\Domain\Model\Article;
use Newland\Toubiz\Sync\Neos\Domain\Repository\WeatherRepository;
use Newland\Toubiz\Sync\Neos\Service\WeatherService;

/**
 * The widget controller for the city list widget.
 */
class WeatherController extends AbstractWidgetController
{

    /**
     * @var WeatherRepository
     * @Flow\Inject()
     */
    protected $weatherRepository;

    /**
     * @var WeatherService
     * @Flow\Inject()
     */
    protected $weatherService;

    /**
     * @Flow\InjectConfiguration(package="Newland.Toubiz.Poi.Neos.cityDetails")
     * @var array
     */
    protected $cityDetailsConfiguration;

    /**
     * Main action for this widget.
     *
     * @return void
     */
    public function indexAction(): void
    {
        /** @var Article $article */
        $article = $this->widgetConfiguration['article'];

        if ($this->cityDetailsConfiguration['weather']['enabled'] === false) {
            return;
        }

        $city = $article->getName();

        if (empty($city)) {
            return;
        }

        $weather = $this->weatherService->findByCityArticle($article);
        $forecast = $weather ? $weather->getForecast() : [];
        $this->view->assignMultiple(
            [
                'forecast' => $forecast,
                'mode' => $this->cityDetailsConfiguration['weather']['mode'] ?? null,
                'node' => $this->widgetConfiguration['node'],
            ]
        );
    }
}
