<?php
namespace Newland\Toubiz\Poi\Neos\Service;

/*
 * This file is part of the "toubiz-poi-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\Constants\EntityListType;
use Newland\Toubiz\Sync\Neos\Domain\Model\Article;
use Newland\Toubiz\Sync\Neos\Domain\Model\RelatedLists\EntityList;

class EntityListService
{
    public function getQuery(EntityList $entityList, Article $article = null): array
    {
        $query = [];

        if ($entityList->getType() === EntityListType::CATEGORIES) {
            $query['categories'] = [];
            foreach ($entityList->getIdentifiers() as $identifier) {
                $query['categories'][$identifier] = $identifier;
            }
        }

        if ($entityList->getType() === EntityListType::ARTICLES) {
            $query['identifiers'] = [];
            foreach ($entityList->getIdentifiers() as $identifier) {
                $query['identifiers'][$identifier] = $identifier;
            }
        }

        if ($article && $article->getIsCity()) {
            $query['city'] = $article->getPersistenceObjectIdentifier();
        }

        return $query;
    }
}
