<?php
namespace Newland\Toubiz\Poi\Neos\Tests\Unit\Service;

/*
 * This file is part of the "toubiz-poi-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Tests\UnitTestCase;
use Newland\Toubiz\Api\Constants\EntityListType;
use Newland\Toubiz\Api\ObjectAdapter\Concern\ArticleConstants;
use Newland\Toubiz\Poi\Neos\Service\EntityListService;
use Newland\Toubiz\Sync\Neos\Domain\Model\Article;
use Newland\Toubiz\Sync\Neos\Domain\Model\RelatedLists\EntityList;

class EntityListServiceTest extends UnitTestCase
{
    /**
     * @var EntityListService
     */
    protected $subject;

    public function setUp()
    {
        $this->subject = new EntityListService();
    }

    public function testQueryForCategoryList(): void
    {
        $article = new Article();
        $article->setPersistenceObjectIdentifier('004a4468-10a2-5159-a266-df842ff316a5');
        $article->setMainType(ArticleConstants::TYPE_CITY);

        $entityList = new EntityList(
            EntityListType::CATEGORIES,
            [
                '0078526a-85ec-541a-afa5-9ed9e0ab838f',
                '00b4df7b-d0c4-5370-be49-5484340d27f7',
            ]
        );

        $expected = [
            'categories' => [
                '0078526a-85ec-541a-afa5-9ed9e0ab838f',
                '00b4df7b-d0c4-5370-be49-5484340d27f7',
            ],
            'city' => '004a4468-10a2-5159-a266-df842ff316a5',
        ];

        $this->assertEquals($expected, $this->subject->getQuery($entityList, $article, [ EntityListType::CATEGORIES => 'categories', 'city' => 'city' ]));
    }

    public function testQueryForIdentifierList(): void
    {
        $article = new Article();
        $article->setPersistenceObjectIdentifier('004a4468-10a2-5159-a266-df842ff316a5');
        $article->setMainType(ArticleConstants::TYPE_ATTRACTION);

        $entityList = new EntityList(
            EntityListType::ARTICLES,
            [
                '0078526a-85ec-541a-afa5-9ed9e0ab838f',
                '00b4df7b-d0c4-5370-be49-5484340d27f7',
            ]
        );

        $expected = [
            'identifiers' => [
                '0078526a-85ec-541a-afa5-9ed9e0ab838f',
                '00b4df7b-d0c4-5370-be49-5484340d27f7',
            ],
        ];

        $this->assertEquals($expected, $this->subject->getQuery($entityList, $article, [ EntityListType::ARTICLES => 'identifiers', 'city' => 'city' ]));
    }
}
