<?php
namespace Newland\Toubiz\Poi\Neos\Tests\Unit\ViewHelpers\Filter;

/*
 * This file is part of the "toubiz-poi-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Tests\UnitTestCase;
use Newland\NeosCommon\Domain\Model\Topic;
use Newland\Toubiz\Poi\Neos\Domain\Repository\TopicRepository;
use Newland\Toubiz\Poi\Neos\ViewHelpers\Filter\QueryViewHelper;

class QueryViewHelperTest extends UnitTestCase
{
    /**
     * @var QueryViewHelper
     */
    protected $subject;

    public function setUp(): void
    {
        $this->subject = new QueryViewHelper();
    }

    public function testQueryForCategory(): void
    {
        $topic = new Topic(TopicRepository::TYPE_CATEGORY, 'foo', 'Hiking');

        $this->assertEquals([ 'category' => [ 'foo' ] ], $this->subject->render($topic));
    }

    public function testQueryForAttribute(): void
    {
        $topic = new Topic(TopicRepository::TYPE_ATTRIBUTE, 'difficultyRating', 'Easy', 1);

        $this->assertEquals([ 'attribute' => [ 'difficultyRating:1' ] ], $this->subject->render($topic));
    }
}
