<?php

/*
 * This file is part of the "toubiz-poi-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

namespace Newland\Toubiz\Poi\Neos\Tests\Unit\Service;

use Neos\Flow\Tests\UnitTestCase;
use Newland\Toubiz\Poi\Neos\Service\RegionService;
use Newland\Toubiz\Poi\Neos\Tests\Unit\Service\Fixtures\MockConfigurationManager;
use Symfony\Component\Yaml\Yaml;

class RegionServiceTest extends UnitTestCase
{
    /**
     * @var RegionService
     */
    public $subject;
    /**
     * @var Yaml
     */
    public $yamlReader;

    public function setUp(): void
    {
        $this->yamlReader = new Yaml();
        $this->subject = new RegionService();
        $this->inject($this->subject, 'configurationManager', new MockConfigurationManager());
    }

    /**
     * @param array $regionKeys
     * @param array $zips
     *
     * @dataProvider getZipFromRegionKeysExamples
     */
    public function testGetZipsFromRegionKeys(array $regionKeys, array $zips)
    {
        $this->assertEquals($zips, $this->subject->getZipsFromRegionKeys($regionKeys));
    }

    public function getZipFromRegionKeysExamples()
    {
        return [
            [
                [
                    'konstanz',
                ],
                [
                    78462,
                    78464,
                    78465,
                    78467,
                ],
            ],
            [
                [
                    'konstanz',
                    'looptown',
                ],
                [
                    78462,
                    78464,
                    78465,
                    78467,
                ],
            ],
            [
                [
                    'konstanz',
                    'radolfzell',
                ],
                [
                    78462,
                    78464,
                    78465,
                    78467,
                    78315,
                    78224,
                ],
            ],
            [
                [
                    'bodensee',
                ],
                [
                    78462,
                    78464,
                    78465,
                    78467,
                    78315,
                    78224,
                ],
            ],
            [
                [
                    'bodensee',
                    'konstanz',
                ],
                [
                    78462,
                    78464,
                    78465,
                    78467,
                    78315,
                    78224,
                ],
            ],
        ];
    }
}
