<?php
namespace Newland\Toubiz\Poi\Neos\ViewHelpers\Widget;

/*
 * This file is part of the "toubiz-poi-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\Annotations as Flow;
use Newland\NeosCommon\ViewHelpers\AbstractWidgetViewHelper;
use Newland\Toubiz\Poi\Neos\ViewHelpers\Widget\Controller\LinkListController;
use Newland\Toubiz\Sync\Neos\Domain\Model\Article;

class LinkListViewHelper extends AbstractWidgetViewHelper
{
    /**
     * @var LinkListController
     * @Flow\Inject()
     */
    protected $controller;

    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('node', NodeInterface::class, null, true);
        $this->registerArgument('article', Article::class, null, true);
    }
}
