<?php
namespace Newland\Toubiz\Poi\Neos\ViewHelpers\Uri\OutdoorActive;

use Neos\Flow\Annotations as Flow;
use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;
use Neos\FluidAdaptor\View\StandaloneView;
use Newland\Toubiz\Sync\Neos\Domain\Model\Article;

abstract class AbstractOutdoorActiveUriViewHelper extends AbstractViewHelper
{
    /**
     * Must return a URL template that may contain one of the following placeholders:
     * - `{article}`: The complete article Object
     * - `{outdoorActive.client}`: Outdoor active project
     * - `{outdoorActive.apiKey}`: Outdoor active api Key
     * @return string
     */
    abstract protected function url(): string;

    /**
     * @var array
     * @Flow\InjectConfiguration(package="Newland.Toubiz.Sync.Neos", path="services.Outdooractive/Api")
     */
    protected $outdoorActiveConfig;

    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('article', Article::class, 'The article for which to generate the URL', true);
    }

    public function render(): string
    {
        /** @var StandaloneView $view */
        $view = $this->objectManager->get(StandaloneView::class);
        $view->setTemplateSource($this->url());
        $view->assignMultiple(
            [
            'article' => $this->arguments['article'],
            'outdoorActive' => $this->outdoorActiveConfig,
            ]
        );

        return $view->render();
    }
}
