<?php
namespace Newland\Toubiz\Poi\Neos\ViewHelpers;

/*
 * This file is part of the "toubiz-poi-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;

class RatingAverageViewHelper extends AbstractViewHelper
{
    /**
     * The ratings for this package.
     *
     * @var array
     */
    protected $rating = [];

    public function initializeArguments(): void
    {
        $this->registerArgument('ratingValue', 'integer', null, false, null);
    }


    public function render(): array
    {
        $ratingValue = $this->arguments['ratingValue'];
        for ($i = 0; $i < 5; $i++) {
            if (($ratingValue / 20) >= ($i + 0.5) && ($ratingValue / 20) < ($i + 1)) {
                $this->rating[$i] = 'half';
            } elseif (($ratingValue / 20) >= ($i + 1)) {
                $this->rating[$i] = 'full';
            } else {
                $this->rating[$i] = '';
            }
        }
        return $this->rating;
    }
}
