<?php
namespace Newland\Toubiz\Poi\Neos\ViewHelpers\Collection\Attributes;

/*
 * This file is part of the "neos-viewhelpers" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Doctrine\Common\Collections\Collection;
use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;
use Newland\Toubiz\Sync\Neos\Domain\Model\Attribute;

class BestSeasonViewHelper extends AbstractViewHelper
{
    protected const ATTRIBUTE_NAME = 'bestSeason';
    protected static $months = [ 'jan', 'feb', 'mar', 'apr', 'may', 'jun', 'jul', 'aug', 'sep', 'oct', 'nov', 'dec' ];

    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('attributes', Collection::class, 'Attributes to filter', true);
    }

    public function render(): array
    {
        $attributes = $this->arguments['attributes']->getValues();
        $onlyBestSeasonAttributes = array_filter(
            $attributes,
            function (Attribute $attribute) {
                return $attribute->getName() === static::ATTRIBUTE_NAME;
            }
        );
        $bestSeasonMonths = array_map(
            function (Attribute $attribute) {
                return $attribute->getData();
            },
            $onlyBestSeasonAttributes
        );


        $bestSeason = [];
        foreach (static::$months as $month) {
            $bestSeason[$month] = in_array($month, $bestSeasonMonths, true);
        }

        return $bestSeason;
    }
}
