<?php

namespace Newland\Toubiz\Poi\Neos\PageFrame;

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\Annotations as Flow;
use Newland\PageFrameProvider\Definition\RoutingConfigurationHelper;
use Newland\PageFrameProvider\Routing\UriResolver;
use Newland\PageFrameProvider\Service\PageFrameLinkingService;

/**
 * @Flow\Scope("singleton")
 */
class ArticleUriResolver implements UriResolver
{

    // Constants that identify the POI plugin.
    public const PACKAGE = 'newland.toubiz.poi.neos';
    public const CONTROLLER = 'pointofinterests';
    public const ACTION = 'show';

    // Plugin namespace as setup by the Fusion Object.
    public const ARGUMENT_NAMESPACE = PageFrameLinkingService::DEFAULT_ARGUMENT_NAMESPACE;

    // The plugin argument that is used to determine the article type.
    public const TYPE_ARGUMENT = '_type';

    // Configuration key to use if there is no detail URL for the specific article type.
    protected const TYPE_FALLBACK = '_fallback';

    // Url that is used if there is not even a `_fallback` configured (instead of simply failing altogether).
    protected const ULTIMATE_FALLBACK_URL = 'poi/detail';

    /**
     * @var array
     * @Flow\InjectConfiguration(package="Newland.Toubiz.Poi.Neos", path="detailPage")
     */
    protected $typeConfiguration;

    /**
     * @var RoutingConfigurationHelper
     * @Flow\Inject()
     */
    protected $configurationHelper;

    /**
     * @var PageFrameLinkingService
     * @Flow\Inject()
     */
    protected $pageFrameLinkingService;

    public function getMatchingDomainSpecificPath(string $requestPath): ?string
    {
        $this->configurationHelper->setTypeConfiguration($this->typeConfiguration);
        return $this->configurationHelper->getUriSegmentsFromRoutePath($requestPath);
    }

    public function resolveDomainSpecificPath(array &$routeValues, NodeInterface $node): ?string
    {
        $this->configurationHelper->setTypeConfiguration($this->typeConfiguration);
        if (!$this->isTryingToBuildArticleUrl($routeValues)) {
            return null;
        }

        $type = $routeValues[static::ARGUMENT_NAMESPACE][static::TYPE_ARGUMENT]
            ?? static::TYPE_FALLBACK;
        unset($routeValues[static::ARGUMENT_NAMESPACE][static::TYPE_ARGUMENT]);
        return $this->configurationHelper->urlFragmentForType($type) ?? static::ULTIMATE_FALLBACK_URL;
    }

    private function isTryingToBuildArticleUrl(array $routeValues): bool
    {
        $type = $routeValues[static::ARGUMENT_NAMESPACE][static::TYPE_ARGUMENT] ?? null;

        $isPageFrameActionLink = $this->pageFrameLinkingService->isPageFrameActionLink(
            $routeValues,
            static::PACKAGE,
            static::CONTROLLER,
            static::ACTION,
            static::ARGUMENT_NAMESPACE
        );

        return $isPageFrameActionLink && $type !== null;
    }
}
