<?php
namespace Newland\Toubiz\Poi\Neos\ViewHelpers\Tag;

/*
 * This file is part of the "toubiz-poi-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Neos\ContentRepository\Domain\Model\Node;
use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;
use Newland\Toubiz\Poi\Neos\Domain\Model\Tag;
use Newland\Toubiz\Poi\Neos\Service\TagTranslationService;

class TitleViewHelper extends AbstractViewHelper
{
    /**
     * @var TagTranslationService
     * @Flow\Inject
     */
    protected $tagTranslationService;

    public function render(Tag $tag, Node $node)
    {
        return $this->tagTranslationService->getTitle($tag, $node);
    }
}
