<?php
namespace Newland\Toubiz\Poi\Neos\ViewHelpers\Filter\Controller;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\Annotations as Flow;
use Neos\Flow\Mvc\View\ViewInterface;
use Neos\FluidAdaptor\Core\Widget\AbstractWidgetController;
use Neos\FluidAdaptor\View\TemplateView;
use Newland\Toubiz\Poi\Neos\Domain\Repository\TopicRepository;
use Newland\Toubiz\Sync\Neos\Domain\Filter\CategoryFilter;
use Newland\Toubiz\Sync\Neos\Domain\Model\Category;
use Newland\Toubiz\Sync\Neos\Domain\Repository\AttributeRepository;
use Newland\Toubiz\Sync\Neos\Domain\Repository\CategoryRepository;
use TYPO3Fluid\Fluid\Core\ViewHelper\ViewHelperVariableContainer;

class FieldSetController extends AbstractWidgetController
{
    /**
     * @var TopicRepository
     * @Flow\Inject()
     */
    protected $topicRepository;

    /**
     * @var AttributeRepository
     * @Flow\Inject()
     */
    protected $attributeRepository;

    /**
     * @var CategoryRepository
     * @Flow\Inject()
     */
    protected $categoryRepository;

    /**
     * @var array
     */
    protected $viewHelperVariables = [];

    public function passViewHelperVariables(ViewHelperVariableContainer $container, array $viewHelpers)
    {
        foreach ($viewHelpers as $class) {
            $this->viewHelperVariables[$class] = $container->getAll($class) ?: [];
        }
    }

    /**
     * @param TemplateView $view
     */
    public function initializeView(ViewInterface $view)
    {
        foreach ($this->viewHelperVariables as $class => $variables) {
            $view->getRenderingContext()->getViewHelperVariableContainer()->addAll($class, $variables);
        }
    }

    public function indexAction()
    {
        $type = $this->widgetConfiguration['fieldSet']['type'];

        $this->view->assignMultiple(
            [
                'fieldSet' => $this->widgetConfiguration['fieldSet'],
                'type' => $type,
                'random' => md5(mt_rand()),
                'nodeIdentifier' => $this->getNodeIdentifier(),
            ]
        );

        $method = 'handle' . ucfirst($type);
        if (method_exists($this, $method)) {
            $this->{$method}();
        }
    }

    private function handleCategories()
    {
        $fieldSet = $this->widgetConfiguration['fieldSet'];

        $properties = $this->widgetConfiguration['node']->getNodeData()->getProperties();
        $fieldSet['searchable'] = true;

        $filter = new CategoryFilter();
        $filter->orderByRelation('category.articles', 'articles', 'DESC');

        if (!empty($properties) && array_key_exists('articleType', $properties)) {
            $filter->setArticleMainType($properties['articleType']);
        } elseif (array_key_exists('mainType', $fieldSet)) {
            $filter->setArticleMainType($fieldSet['mainType']);
        }


        $topics = array_map(
            function (Category $category) {
                return $this->topicRepository->findByCategory($category->getPersistenceObjectIdentifier());
            },
            $this->categoryRepository->findByFilter($filter)
        );
        foreach ($topics as $topic) {
            $topic->setValue($topic->getIdentifier());
        }
        $this->view->assignMultiple(
            [
                'type' => 'checkboxes',
                'items' => $topics,
                'fieldSet' => $fieldSet,
            ]
        );
    }

    private function handleCheckboxes()
    {
        $this->view->assignMultiple(
            [
                'items' => $this->topicRepository->findByIdentifiers($this->widgetConfiguration['fieldSet']['items']),
            ]
        );
    }

    private function handleRange()
    {
        $steps = $this->widgetConfiguration['fieldSet']['steps'] ?? 1;
        $factor = $this->widgetConfiguration['fieldSet']['factor'] ?? 1;
        $min = $this->widgetConfiguration['fieldSet']['min'] ?? null;
        $max = $this->widgetConfiguration['fieldSet']['max'] ?? null;

        if (!$min || !$max) {
            list(, $name) = explode(':', $this->widgetConfiguration['fieldSet']['item']);
            $roundAutoBounds = $this->widgetConfiguration['fieldSet']['roundAutoBounds'] ?? 100;
            $bounds = $this->attributeRepository->getNumberBoundsForName($name, $roundAutoBounds);
            $min = $min ?? $bounds['min'];
            $max = $max ?? $bounds['max'];
        }

        $this->view->assignMultiple(
            [
                'item' => $this->topicRepository->findByIdentifier($this->widgetConfiguration['fieldSet']['item']),
                'min' => $min,
                'max' => $max,
                'steps' => $steps,
                'factor' => $factor,
            ]
        );
    }

    private function getNodeIdentifier(): string
    {
        /** @var NodeInterface $node */
        $node = $this->widgetConfiguration['node'];
        $nodeIdentifier = $node->getIdentifier();

        return $nodeIdentifier;
    }
}
