<?php
namespace Newland\Toubiz\Poi\Neos\Domain\Repository;

/*
 * This file is part of the "toubiz-poi-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Poi\Neos\Domain\Model\Tag;
use Newland\Toubiz\Sync\Neos\Domain\Model\Category;

class TagRepository
{

    public function findOneByCategory(Category $category): Tag
    {
        $tag = new Tag();
        $tag->setTitle($category->getTitle());
        $tag->setAttributeType(TopicRepository::TYPE_CATEGORY);
        $tag->setIdentifier($category->getPersistenceObjectIdentifier());
        $tag->setValue($category->getPersistenceObjectIdentifier());

        return $tag;
    }

    public function findOneByProperty(string $property)
    {
        return $this->findOneByBooleanAttribute('properties:' . $property);
    }

    public function findOneByLabel(string $label): Tag
    {
        return $this->findOneByBooleanAttribute('labels:' . $label);
    }

    public function findOneByRange(string $attribute, array $attributeValues): Tag
    {
        $tag = new Tag();
        $tag->setAttribute($attribute);
        $tag->setAttributeType(Tag::TYPE_RANGE);
        $tag->setValue($attributeValues['min'] . ';' . $attributeValues['max']);
        $tag->setIdentifier(TopicRepository::TYPE_ATTRIBUTE . ':' . $tag->getAttribute());

        return $tag;
    }

    public function findOneByValue(string $attribute, string $value): Tag
    {
        $tag = new Tag();
        $tag->setAttribute($attribute);
        $tag->setAttributeType(Tag::TYPE_STRING);
        $tag->setValue($value);
        $tag->setIdentifier(TopicRepository::TYPE_ATTRIBUTE . ':' . $tag->getAttribute() . ':' . $value);

        return $tag;
    }

    private function findOneByBooleanAttribute(string $attribute)
    {
        $tag = new Tag();
        $tag->setAttribute($attribute);
        $tag->setAttributeType(Tag::TYPE_BOOLEAN);
        $tag->setValue(true);
        $tag->setIdentifier(TopicRepository::TYPE_ATTRIBUTE . ':' . $tag->getAttribute());

        return $tag;
    }
}
