<?php

namespace Newland\Toubiz\Poi\Neos\Domain\Model;

class Tag
{
    const TYPE_BOOLEAN = 'boolean';
    const TYPE_RANGE = 'range';
    const TYPE_STRING = 'string';

    private $attribute = '';

    private $value = '';

    private $attributeType = '';

    private $identifier = '';

    private $combinedIdentifier = '';

    private $title = '';

    public function getAttribute(): string
    {
        return $this->attribute;
    }

    public function setAttribute(string $attribute)
    {
        $this->attribute = $attribute;
    }

    public function getValue(): string
    {
        return $this->value;
    }

    public function setValue(string $value)
    {
        $this->value = $value;
    }

    public function getAttributeType(): string
    {
        return $this->attributeType;
    }

    public function setAttributeType(string $attributeType)
    {
        $this->attributeType = $attributeType;
    }

    public function getIdentifier(): string
    {
        return $this->identifier;
    }

    public function setIdentifier(string $identifier)
    {
        $this->identifier = $identifier;
    }

    public function getCombinedIdentifier(): string
    {
        $identifier = $this->attributeType . ':' . $this->identifier;
        if ($this->value) {
            $identifier .= ':' . $this->value;
        }
        return $identifier;
    }

    public function setCombinedIdentifier(string $combinedIdentifier)
    {
        $this->combinedIdentifier = $combinedIdentifier;
    }

    public function getTitle(): string
    {
        return $this->title;
    }

    public function setTitle(string $title)
    {
        $this->title = $title;
    }
}
