<?php
namespace Newland\Toubiz\Poi\Neos\ViewHelpers\Filter;

use Neos\FluidAdaptor\Core\ViewHelper\AbstractTagBasedViewHelper;
use Newland\Toubiz\Poi\Neos\Domain\Model\Tag;

class TagViewHelper extends AbstractTagBasedViewHelper
{
    protected $tagName = 'li';

    public function initializeArguments()
    {
        $this->registerUniversalTagAttributes();
    }

    /**
     * @param Tag $tag
     * @return string
     */
    public function render(Tag $tag)
    {
        $this->tag->setContent($tag->getTitle());
        $this->tag->addAttribute('data-id', $tag->getIdentifier());

        return $this->tag->render();
    }
}
