<?php
namespace Newland\Toubiz\Poi\Neos\ViewHelpers\Filter\Controller;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\Annotations as Flow;
use Neos\Flow\Mvc\View\ViewInterface;
use Neos\FluidAdaptor\Core\Widget\AbstractWidgetController;
use Neos\FluidAdaptor\View\TemplateView;
use Newland\Toubiz\Poi\Neos\Domain\Repository\TopicRepository;
use Newland\Toubiz\Sync\Neos\Domain\Filter\CategoryFilter;
use Newland\Toubiz\Sync\Neos\Domain\Model\Category;
use Newland\Toubiz\Sync\Neos\Domain\Repository\CategoryRepository;
use TYPO3Fluid\Fluid\Core\ViewHelper\ViewHelperVariableContainer;

class FieldSetController extends AbstractWidgetController
{

    /**
     * @var TopicRepository
     * @Flow\Inject()
     */
    protected $topicRepository;

    /**
     * @var CategoryRepository
     * @Flow\Inject()
     */
    protected $categoryRepository;

    /**
     * @var array
     */
    protected $viewHelperVariables = [];

    public function passViewHelperVariables(ViewHelperVariableContainer $container, array $viewHelpers)
    {
        foreach ($viewHelpers as $class) {
            $this->viewHelperVariables[$class] = $container->getAll($class) ?: [];
        }
    }

    /**
     * @param TemplateView $view
     */
    public function initializeView(ViewInterface $view)
    {
        foreach ($this->viewHelperVariables as $class => $variables) {
            $view->getRenderingContext()->getViewHelperVariableContainer()->addAll($class, $variables);
        }
    }

    public function indexAction()
    {
        $type = $this->widgetConfiguration['fieldSet']['type'];

        $this->view->assignMultiple(
            [
                'fieldSet' => $this->widgetConfiguration['fieldSet'],
                'type' => $type,
                'random' => md5(mt_rand()),
                'nodeIdentifier' => $this->getNodeIdentifier(),
            ]
        );

        $method = 'handle' . ucfirst($type);
        if (method_exists($this, $method)) {
            $this->{$method}();
        }
    }

    private function handleCategories()
    {
        $fieldSet = $this->widgetConfiguration['fieldSet'];
        $fieldSet['searchable'] = true;

        $filter = new CategoryFilter();
        $filter->orderByRelation('category.articles', 'articles', 'DESC');
        if (array_key_exists('mainType', $fieldSet)) {
            $filter->setArticleMainType($fieldSet['mainType']);
        }

        $topics = array_map(
            function (Category $category) {
                return $this->topicRepository->topicFromCategory($category);
            },
            $this->categoryRepository->findByFilter($filter)
        );

        $this->view->assignMultiple(
            [
                'type' => 'checkboxes',
                'items' => $topics,
                'fieldSet' => $fieldSet,
            ]
        );
    }

    private function handleCheckboxes()
    {
        $this->view->assignMultiple(
            [
                'items' => $this->topicRepository->findByIdentifiers($this->widgetConfiguration['fieldSet']['items']),
            ]
        );
    }

    private function handleRange()
    {
        $this->view->assignMultiple(
            [
                'item' => $this->topicRepository->findByIdentifier($this->widgetConfiguration['fieldSet']['item']),
            ]
        );
    }

    private function getNodeIdentifier(): string
    {
        /** @var NodeInterface $node */
        $node = $this->widgetConfiguration['node'];
        $nodeIdentifier = $node->getIdentifier();

        return $nodeIdentifier;
    }
}
