<?php
namespace Newland\Toubiz\Poi\Neos\ViewHelpers\Context;

/*
 * This file is part of the "toubiz-poi-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\Node;
use Neos\Eel\FlowQuery\FlowQuery;
use Neos\Flow\Annotations as Flow;
use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;
use Newland\Toubiz\Poi\Neos\Service\ArticleUrlService;
use Newland\Toubiz\Sync\Neos\Domain\Model\Article;

/**
 * Target URI view helper.
 *
 * Returns the target URI for a given article if the link has to be external.
 */
class TargetUriViewHelper extends AbstractViewHelper
{
    /**
     * @Flow\Inject
     * @var ArticleUrlService
     */
    protected $articleUrlService;

    /**
     * Main method.
     *
     * This may also return null in case the article is not present anymore.
     *
     * @param Article|null $article
     * @return string|null
     */
    public function render(Article $article = null)
    {
        if (!$article) {
            return null;
        }

        return $this->articleUrlService->generateLodgingUrl($article);
    }
}
