<?php

namespace Newland\Toubiz\Poi\Neos\Service;

use Neos\Flow\Annotations as Flow;
use Neos\Flow\I18n\Translator;
use Newland\Toubiz\Poi\Neos\Utility\ArrayUtility;

/**
 * @Flow\Scope("singleton")
 */
class TopicService
{

    /**
     * @var Translator
     * @Flow\Inject()
     */
    protected $translator;

    /**
     * @var array
     * @Flow\InjectConfiguration(package="Newland.Toubiz.Poi.Neos", path="attributes.i18n")
     */
    protected $translationConfiguration;

    /**
     * @param string $name
     * @param string|null $value
     * @return string
     */
    public function titleForAttribute(string $name, $value = null): string
    {
        $label = 'attribute.' . $name;
        if (\is_string($value)) {
            $label .= '.' . $value;
        }

        $configurations = $this->translationConfiguration;
        $configurations[] = [ 'package' => 'Newland.Toubiz.Poi.Neos' ];

        foreach ($configurations as $config) {
            $source = array_key_exists('source', $config) ? $config['source'] : 'Models/Topic';
            $package = $config['package'];
            $title = $this->translator->translateById($label, [], null, null, $source, $package);
            if ($title) {
                return $title;
            }
        }

        return $label;
    }

}