<?php

namespace Newland\Toubiz\Poi\Neos\DataSource;

/*
 * This file is part of the "toubiz-poi-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\Node;
use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\Annotations as Flow;
use Neos\Flow\I18n\Translator;
use Neos\Flow\Persistence\PersistenceManagerInterface;
use Neos\Neos\Service\DataSource\AbstractDataSource;
use Newland\Toubiz\Poi\Neos\Domain\Model\Topic;
use Newland\Toubiz\Poi\Neos\Domain\Repository\TopicRepository;
use Newland\Toubiz\Poi\Neos\Service\TopicService;
use Newland\Toubiz\Poi\Neos\Utility\ArrayUtility;
use Newland\Toubiz\Sync\Neos\Domain\Filter\CategoryFilter;
use Newland\Toubiz\Sync\Neos\Domain\Repository\AttributeRepository;
use Newland\Toubiz\Sync\Neos\Domain\Repository\CategoryRepository;

/**
 * Categories data source service.
 *
 * @Flow\Scope("singleton")
 */
class TopicsDataSource extends AbstractDataSource
{
    /**
     * Data source identifier.
     *
     * @var string
     */
    static protected $identifier = 'newland-toubiz-poi-neos-topics';

    /**
     * @var Translator
     * @Flow\Inject
     */
    protected $translator;

    /**
     * @var TopicRepository
     * @Flow\Inject
     */
    protected $topicRepository;

    /**
     * Get requested data from source.
     *
     * The return value must be JSON serializable data structure.
     *
     * @api
     * @param NodeInterface $node The node that is currently edited (optional)
     * @param array $arguments Additional arguments (key / value)
     * @return mixed JSON serializable data
     * @throws \Neos\ContentRepository\Exception\NodeException
     */
    public function getData(NodeInterface $node = null, array $arguments = [])
    {
        $groups = [
            Topic::TYPE_ATTRIBUTE => $this->translate('attributes'),
            Topic::TYPE_CATEGORY => $this->translate('categories'),
        ];

        $articleType = null;
        if ($node && $node->hasProperty('articleType')) {
            $articleType = $node->getProperty('articleType');
        }

        return array_map(
            function (Topic $topic) use ($groups) {
                return [
                    'label' => $topic->getTitle(),
                    'value' => $topic->getIdentifier(),
                    'group' => $groups[$topic->getType()],
                ];
            },
            $this->topicRepository->findAll($articleType)
        );
    }

    /**
     * @param string $id
     * @return string|null
     */
    private function translate(string $id)
    {
        return $this->translator->translateById(
            $id,
            [],
            null,
            null,
            'NodeTypes/FilteredLists',
            'Newland.Toubiz.Poi.Neos'
        );
    }
}
