<?php
namespace Newland\Toubiz\Poi\Neos\Controller;

/*
 * This file is part of the "toubiz-poi-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Poi\Neos\Domain\Repository\TopicRepository;
use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Sync\Neos\Domain\Repository\ArticleRepository;

/**
 * @Flow\Scope("singleton")
 */
class FilteredListsController extends AbstractActionController
{

    /**
     * @var TopicRepository
     * @Flow\Inject
     */
    protected $topicRepository;

    /**
     * @Flow\Inject
     * @var ArticleRepository
     */
    protected $articleRepository;

    /**
     * @var array
     * @Flow\InjectConfiguration("filter.sections")
     */
    protected $filterSections;


    public function indexAction()
    {
        $topics = $this->topicRepository->findByIdentifiers($this->properties['topics'] ?? []);
        $lists = $this->topicRepository->findByCategories($this->properties['lists'] ?? []);

        $this->view->assignMultiple(
            [
                'topics' => $topics,
                'lists' => $lists,
                'filterSections' => $this->filterSections,
            ]
        );
    }

    /**
     * Filter list action.
     *
     * Returns articles based on given filters.
     *
     * @param array $query The filter query.
     * @return string
     */
    public function showAction(array $query = [])
    {
        $this->initializeAction();
        $articleFilter = $this->initializeFilter($this->node, $query);
        if (array_key_exists('page', $query) && !empty($query['page'])) {
            $page = (int) $query['page'];
            $articleFilter->setOffset(($page - 1) * $this->configuration['resultsPerPage']);
        } else {
            $page = 1;
        }

        $articles = $this->articleRepository->findByFilter($articleFilter);
        $articleCounts = $this->articleRepository->countByFilter($articleFilter, $this->configuration['resultsPerPage']);

        $this->view->assignMultiple(
            [
                'filterSections' => $this->filterSections,
                'query' => $query,
                'articles' => $articles,
                'pagination' => [
                    'isFirst' => ($page == 1),
                    'page' => $page,
                    'isLast' => $articleCounts['pages'] <= $page,
                    'count' => $articleCounts,
                ],
            ]
        );


    }

}
