<?php
namespace Newland\Toubiz\Poi\Neos\ViewHelpers\Topic;

/*
 * This file is part of the "toubiz-poi-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Neos\FluidAdaptor\Core\Widget\AbstractWidgetViewHelper;
use Newland\NeosCommon\Domain\Model\Topic;
use Newland\Toubiz\Poi\Neos\ViewHelpers\Topic\Controller\ArticlesController;

class ArticlesViewHelper extends AbstractWidgetViewHelper
{
    /**
     * @var ArticlesController
     * @Flow\Inject
     */
    protected $controller;

    public function initializeArguments()
    {
        parent::initializeArguments();
        $this->registerArgument('topic', Topic::class, 'The selected topic.', true);
        $this->registerArgument('queryOverride', 'array', 'Query override for additional filtering.', false, []);
        $this->registerArgument('limit', 'integer', 'Query override for additional filtering.', false, 11);
    }

    public function render()
    {
        $response = $this->initiateSubRequest();
        return (string) $response->getBody();
    }
}
