# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [unreleased]
### Changed
- Data sources for articles can no be limited to main type.
- Scope name of article indexer has changed to `toubiz_articles`
- Gastronomy articles now display the discription in detail view.

## [1.8.1] - 2019-05-09
### Added
- Hook to build article URLs on sync

### Fixed
- Previously selected non-existent topics are now displayed in backend to allow removing them

## [1.8.0] - 2019-05-08
### Added
- POIs are now language aware

### Changed
- Gallery images are now displayed in the order as defined during import 
- Article attributes are not checked for existence when populating the pre-filter field in the backend

## [1.7.1] - 2019-04-18
### Fixed
- Fixed days in opening times being offset by 1
- Opening times table now takes non-regular opening times into account
- Opening times are no longer displayed if none exist

### Changed
- Opening Times Table now starts at the current day

## [1.7.0] - 2019-04-17
### Added
- Opening times to article detail view 
- Attributes for Direct Marketers are now synched and displayed 
- New social media information is now fetched 
- Templates for direct marketers

### Changed
- tportalViewHelper adapted to allow fixed properties 
- Prefiltered regions are applied on more than just one filtered list.
- Dependency to toubiz-search-neos is now versions instead of a specific feature branch.

### Fixed
- Galery duplicates

## [1.6.0] - 2019-04-04
### Added
- Support for custom breadcrumbs for detail pages.
- Support for multilingual detail pages
- LinkHandler support is now bundled by default.

### Changed
- `Newland.Toubiz.Poi.Neos:List` is now `Newland.Toubiz.Poi.Neos:List*` for each article type
- `Newland.Toubiz.Poi.Neos:TeaserList` is now `Newland.Toubiz.Poi.Neos:TeaserList*` for each article type

### Fixed
- Ajax results now generate correct frontend links

### Migration Notes
- Use `$ php flow node:migrate --version 20190314223200` to automatically migrate all lists
- Use `$ php flow node:migrate --version 20190314223900` to automatically migrate all teaser lists
- If you project has Linkhandler configuration (In `Newland.NeosCommon.linkhandler`)
  for Articles under the name `poi` then that configuration can be safely removed.

## [1.5.1] - 2019-03-08
- No functional changes

## [1.5.0] - 2019-03-08
### Added
- FilteredLists and TeaserLists can now be pre-filtered by regions. Regions can
be anything from a group of zip codes to a group of other regions.
- FilteredLists Plugin with a landing page displaying swipers and a grid view with many, many configurable filter options
- Article Detail views are now located on static routes that can be configured
on a per-type basis in `Newland.Toubiz.Poi.Neos.detailPage`. Previous detail URLs
are automatically redirected to the new ones.
- A new `Newland.Article.findByIdentifier` fusion helper has been added.
- Attribute cache can now be rebuilt manually via command `attribute:buildcache`.
- Added a Node Migration to change a legacy property on Teaser Lists

### Changed
- The `List` plugin now has filters associated with it.

### Migration Notices
- Be sure to include the `newland/page-frame-provider` repository in your projects `composer.json`
- Be sure to run `php flow node:migrate` on deployment to correctly adapt existing teaser lists
to the current property, if you want to check the status run `php flow node:migrationstatus`.
