<?php
namespace Newland\Toubiz\Poi\Neos\Listener;

use Newland\Toubiz\Api\ObjectAdapter\Concern\ArticleConstants;
use Newland\Toubiz\Poi\Neos\Service\AttributeTopicService;
use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Sync\Neos\Command\ArticlesCommandController;

class BuildAttributeTopicIdentifierCache
{

    /**
     * @var AttributeTopicService
     * @Flow\Inject()
     */
    protected $attributeTopicService;

    /**
     * @param string $type
     */
    public function run(string $type)
    {
        switch ($type) {
            case ArticlesCommandController::TYPE_TOURS:
                $this->attributeTopicService->generateAndCacheIdentifiers(ArticleConstants::TYPE_TOUR);
                break;
            case ArticlesCommandController::TYPE_GASTRONOMY:
                $this->attributeTopicService->generateAndCacheIdentifiers(ArticleConstants::TYPE_GASTRONOMY);
                break;
            case ArticlesCommandController::TYPE_DIRECT_MARKETERS:
                $this->attributeTopicService->generateAndCacheIdentifiers(ArticleConstants::TYPE_DIRECT_MARKETER);
                break;
            case ArticlesCommandController::TYPE_LODGINGS:
            case ArticlesCommandController::TYPE_POI:
                $this->attributeTopicService->generateAndCacheIdentifiers(ArticleConstants::TYPE_ATTRACTION);
                $this->attributeTopicService->generateAndCacheIdentifiers(ArticleConstants::TYPE_LODGING);
        }
    }
}
