<?php
namespace Newland\Toubiz\Poi\Neos\Listener;

use Doctrine\ORM\EntityManagerInterface;
use Neos\ContentRepository\Domain\Factory\NodeFactory;
use Neos\ContentRepository\Domain\Model\Node;
use Neos\ContentRepository\Domain\Model\NodeData;
use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\ObjectManagement\Exception\InvalidObjectException;
use Neos\Neos\Domain\Model\Domain;
use Neos\Neos\Domain\Model\Site;
use Neos\Neos\Domain\Repository\SiteRepository;
use Neos\Neos\Domain\Service\ContentContext;
use Newland\NeosCommon\Domain\Repository\NodeRepository;
use Newland\NeosCommon\Sitemap\SitemapUrl;
use Newland\Toubiz\Poi\Neos\Service\ArticleUrlService;
use Newland\Toubiz\Sync\Neos\Command\ArticlesCommandController;
use Newland\Toubiz\Sync\Neos\Domain\Repository\ArticleRepository;
use Newland\NeosCommon\Service\ControllerContextFactory;
use Neos\Flow\Annotations as Flow;

/**
 * @Flow\Scope("singleton")
 */
class BuildArticleUrls
{

    /**
     * @Flow\Inject
     * @var NodeRepository
     */
    protected $nodeRepository;

    /**
     * @Flow\Inject
     * @var EntityManagerInterface
     */
    protected $entityManager;

    /**
     * @Flow\Inject
     * @var NodeFactory
     */
    protected $nodeFactory;

    /**
     * @Flow\Inject
     * @var ControllerContextFactory
     */
    protected $contextFactory;

    /**
     * @Flow\Inject
     * @var SiteRepository
     */
    protected $siteRepository;

    /**
     * @var ArticleUrlService
     * @Flow\Inject
     */
    protected $articleUrlService;

    /**
     * @var ArticleRepository
     * @Flow\Inject
     */
    protected $articleRepository;


    const NODE_TYPE = 'Neos.NodeTypes:Page';

    public function run(string $type)
    {

        if ($type === ArticlesCommandController::TYPE_GENERATE) {

            $nodes = $this->nodeRepository
                ->findNodesByNodeType(static::NODE_TYPE, true);

            $context = $this->contextFactory->initializeFakeControllerContext($nodes[0]);

            foreach ($this->articleRepository->findAll() as $article) {

                $url = $this->articleUrlService->generateUrl($article, $context);
                if (!$url) {
                    return null;
                }

                $url = $this->prependDomainIfRelative($url, $this->domain($nodes[0]));
                $pages[] = new SitemapUrl($url);

            }

        }

    }


    private function nodeLabel(Node $node): string
    {
        return $node->getName() . json_encode($node->getDimensions());
    }

    private function prependDomainIfRelative(string $url, Domain $domain): string
    {
        if (strpos($url, 'http') !== false) {
            return $url;
        }

        $domainWithScheme = clone $domain;
        $domainWithScheme->setScheme($domain->getScheme() ?? 'http');
        return ((string) $domainWithScheme) . '/' . ltrim($url, '/');
    }

    /**
     * @param NodeInterface $site
     * @return Domain
     */
    private function domain(NodeInterface $site): Domain
    {
        $contentContext = $site->getContext();
        if (!($contentContext instanceof ContentContext)) {
            return new Domain();
        }

        $domain = $contentContext->getCurrentSite()->getPrimaryDomain();
        return $domain ?? new Domain();
    }


    private function getNode(): array
    {
        $nodes = $this->nodeRepository->findNodesByNodeType(static::NODE_TYPE, true);
    }


}
