<?php
namespace Newland\Toubiz\Poi\Neos\Search\Indexer;

/*
 * This file is part of the "toubiz-poi-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Search\Neos\Indexer\AbstractRecordIndexer;
use Newland\Toubiz\Search\Neos\Indexer\IndexerInterface;
use Newland\Toubiz\Sync\Neos\Domain\Model\Article;
use Newland\Toubiz\Sync\Neos\Domain\Repository\ArticleRepository;

/**
 * Article indexer.
 *
 * Indexes articles for the search.
 *
 * @Flow\Scope("singleton")
 */
class ArticleIndexer extends AbstractRecordIndexer implements IndexerInterface
{
    /**
     * @var ArticleRepository
     * @Flow\Inject
     */
    protected $articleRepository;

    /**
     * Entry point.
     *
     * Indexes article records.
     *
     * @return void
     */
    public function index()
    {
        foreach ($this->articleRepository->findAll() as $article) {
            $this->indexArticle($article);
        }
    }

    /**
     * Runs post-index tasks such as cleaning up old records.
     *
     * @return void
     */
    public function postIndex()
    {
        $this->searchIndexRepository->deleteObsolete(
            $this->index,
            get_class($this)
        );
    }

    /**
     * Indexes a given article.
     *
     * @param Article $article
     * @return void
     */
    protected function indexArticle(Article $article)
    {
        $content = [
            $article->getName(),
            $article->getAbstract(),
            $article->getDescription()
        ];

        $indexData = [
            'identifier' => $article->getPersistenceObjectIdentifier(),
            'source' => get_class($this),
            'title' => $this->convertToIndexableString($article->getName()),
            'description' => $this->convertToIndexableString($article->getAbstract()),
            'content' => $this->convertToIndexableString(implode(' ', $content))
        ];

        $this->addToIndex($indexData);
    }
}
