<?php

/*
 * This file is part of the "toubiz-poi-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

namespace Newland\Toubiz\Poi\Neos\Tests\Unit\Service;

use Neos\Flow\Configuration\ConfigurationManager;
use Neos\Flow\Tests\FunctionalTestCase;
use Newland\Toubiz\Poi\Neos\Service\RegionService;
use Newland\Toubiz\Poi\Neos\Tests\Unit\Service\Fixtures\YamlSourceFixture;

class RegionServiceTest extends FunctionalTestCase
{
    /**
     * @var RegionService
     */
    public $subject;

    public function setUp()
    {
        $configurationManager = new ConfigurationManager(static::$bootstrap->getContext());
        $configurationManager->injectConfigurationSource(
            new YamlSourceFixture(__DIR__ . '/Fixtures/Regions.yml')
        );
        $this->subject = new RegionService();
        $this->subject->injectRegionsAvailable($configurationManager);
        $this->subject->injectRegionsEnabled($configurationManager);
    }

    /**
     * @param array $regionKeys
     * @param array $zips
     *
     * @dataProvider getZipFromRegionKeysExamples
     */
    public function testGetZipsFromRegionKeys(array $regionKeys, array $zips)
    {
        $this->assertEquals($zips, $this->subject->getZipsFromRegionKeys($regionKeys));
    }

    public function getZipFromRegionKeysExamples()
    {
        return [
            [
                [
                    'konstanz',
                ],
                [
                    78462,
                    78464,
                    78465,
                    78467,
                ],
            ],
            [
                [
                    'konstanz',
                    'looptown',
                ],
                [
                    78462,
                    78464,
                    78465,
                    78467,
                ],
            ],
            [
                [
                    'konstanz',
                    'radolfzell',
                ],
                [
                    78462,
                    78464,
                    78465,
                    78467,
                    78315,
                    78224,
                ],
            ],
            [
                [
                    'bodensee',
                ],
                [
                    78462,
                    78464,
                    78465,
                    78467,
                    78315,
                    78224,
                ],
            ],
            [
                [
                    'bodensee',
                    'konstanz',
                ],
                [
                    78462,
                    78464,
                    78465,
                    78467,
                    78315,
                    78224,
                ],
            ],
        ];
    }
}
