<?php
namespace Newland\Toubiz\Poi\Neos\ViewHelpers\Link;

/*
 * This file is part of the "toubiz-poi-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\Node;
use Neos\FluidAdaptor\Core\ViewHelper\AbstractTagBasedViewHelper;
use Newland\Toubiz\Poi\Neos\Service\ArticleUrlService;
use Newland\Toubiz\Sync\Neos\Domain\Model\Article;
use Neos\Flow\Annotations as Flow;

class ArticleViewHelper extends AbstractTagBasedViewHelper
{
    /**
     * @var string
     */
    protected $tagName = 'a';

    /**
     * @var ArticleUrlService
     * @Flow\Inject
     */
    protected $articleUrlService;

    /**
     * @return void
     */
    public function initializeArguments()
    {
        $this->registerUniversalTagAttributes();
        $this->registerTagAttribute('target', 'string', 'Link target (e.g. _blank)');
    }

    /**
     * @param Article $article
     * @param Node $currentNode
     * @return string
     * @throws \Neos\Eel\Exception
     * @throws \Neos\Neos\Exception
     */
    public function render(Article $article = null, Node $currentNode = null): string
    {
        if (!$article) {
            $isInBackend = $this->controllerContext->getRequest()
                ->getInternalArgument('__node')
                ->getContext()
                ->isInBackend();

            if ($isInBackend) {
                return 'Error: No article specified.';
            }
            return '';
        }

        if ($currentNode) {
            $url = $this->articleUrlService->generateUrlByCurrentNode($article, $currentNode);
        } else {
            $url = $this->articleUrlService->generateUrl($article, $this->controllerContext);
        }
        $this->tag->addAttribute('href', $url);
        $this->tag->setContent($this->renderChildren());
        return $this->tag->render();
    }
}
