<?php
namespace Newland\Toubiz\Poi\Neos\ViewHelpers\Filter;

/*
 * This file is part of the "toubiz-poi-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;
use Newland\Toubiz\Poi\Neos\Domain\Model\Topic;

/**
 * Builds a `name` attribute string for the given topic.
 * `append` can be an array that uses the topic type as a key and the items to append
 * as a value. These items will be appended to the name if the topic has the given type.
 */
class NameViewHelper extends AbstractViewHelper
{

    public function render(Topic $topic, array $subPath = [], $dotNotation = true)
    {
        $query = QueryViewHelper::queryPathForTopic($topic, $subPath, true);

        if ($dotNotation) {
            return implode('.', $query);
        }

        return '[' . implode('][', $query) . ']';
    }
}
